*** Figure 6:  Newspapers – Event Study

cd "$path"
global data "$path/data/"
global output "$path/results"

estimates clear 


*** OPEN MAIN COUNTY DTA 
use  "$data/main_newspapers.dta", clear

egen cst=group(statefip countyicp)
sort cst week keyword_victim keyword_place


gen POST=0
replace POST=1 if week>-1

foreach i in ///
LD_Z_p40  LD_fr_black D6040_fr_black Z_40to60_p40 fr_black_40 D_fr_black_in40 D_fr_black_in50 Z_p40_in40 Z_p40_in50 {
    
gen `i'_P=`i'*POST

}
.

egen stateweek=group(statefip week)
egen keyword_joint=group(victim_id  place_id)

compress

distinct cst //492 counties for which we have np data 


foreach i in 4 3 2 1 {
	
rename D6040_fr_black week_minus`i'

ivreghdfe any_mention ( week_minus`i' = Z_40to60_p40 ) ///
[aw=totpop_40] if week==-`i' , a(statefip keyword_joint) cluster(cst)
estimates	store  week_minus`i'

rename   	week_minus`i' D6040_fr_black

}


foreach i in  0 1 2 3 4 5 6 7 8 {
	
rename D6040_fr_black week_plus`i'

ivreghdfe any_mention ( week_plus`i' = Z_40to60_p40 ) ///
[aw=totpop_40] if week==`i' , a(statefip keyword_joint) cluster(cst)
estimates	store  week_plus`i'

rename   	week_plus`i' D6040_fr_black


}
	
	
cd "$output"

coefplot ///
(week_minus4 week_minus3 week_minus2 week_minus1 week_plus0 week_plus1 week_plus2 week_plus3 week_plus4 week_plus5 week_plus6 week_plus7 week_plus8), vertical  yline(0, lcolo(black)) ciopts(recast(rcap) lcolor(maroon)) citop  /// 
keep (week_minus4 week_minus3 week_minus2 week_minus1 week_plus0 week_plus1 week_plus2 week_plus3 week_plus4 week_plus5 week_plus6 week_plus7 week_plus8) ///
coeflabels( week_minus4="-4" week_minus3="-3" week_minus2="-2" week_minus1="-1" week_plus0="0" week_plus1="+1" week_plus2="+2"  week_plus3="+3" week_plus4="+4" week_plus5="+5" week_plus6="+6"  week_plus7="+7" week_plus8="+8" , wrap(17)) ///
legend(off) ytitle("2SLS Coefficient on change in Black share") xline(5,lcolor(black))  yline(0,lcolor(black)) graphregion(fcolor(white) ilcolor(white) lcolor(white)) ylabel(-0.5(.5)2, nogrid)  xla(, notick) 
 

graph export "$output/Figure6.eps", replace






 